#include <iostream>
#include <queue>
#include <vector>
#include <set>

using namespace std;

const unsigned int maxn = (1<<17);

vector < unsigned int > ln [maxn];
pair < unsigned int , unsigned int > levels [maxn]; /// <up, down>

bool visited [maxn];
unsigned int n;

unsigned int answer = 1e9;
vector < unsigned int > answers;
set < unsigned int > to_try;

vector < pair < unsigned int , unsigned int > > deepest_child (unsigned int start, unsigned int parent = -1, unsigned int depth = 0)
{
    vector < pair < unsigned int, unsigned int > > answer = {{start, depth}};
    for (auto next : ln [start])
    {
        if (next != parent)
        {
            auto x = deepest_child(next, start, depth + 1);
            if (x[0].second > answer[0].second)
                answer = x;
            else if (x [0].second == answer [0].second)
            {
                for (auto y : x)
                    answer.push_back(y);
            }
        }
    }
    return answer;
}

void add_path_between (unsigned int a, unsigned int b)
{
    visited [a] = true;
    if (a == b)
    {
        for (unsigned int i = 0 ; i < n ; i ++)
            if (visited [i])
                to_try.insert (i);
        return ;
    }
    for (auto& x : ln [a])
        if (!visited [x])
        {
            visited [x] = true;
            add_path_between(x, b);
            visited [x] = false;
        }
}

unsigned int max_depth (unsigned int start)
{
    for (unsigned int i = 0 ; i < n ; i ++)
        visited [i] = false;

    unsigned int depth = 0;
    queue < pair < unsigned int, unsigned int > > q;
    q.push ({start, 0});
    visited [start] = true;

    while (!q.empty ())
    {
        auto front = q.front(); q.pop();
        //cout << front.second << endl;
        depth = max (depth, front.second);
        for (auto next : ln [front.first])
        {
            if (!visited [next])
            {
                visited [next] = true;
                q.push({next, front.second + 1});
            }
        }
    }
    return depth;
}

int main ()
{
    cin.tie(nullptr);
    ios::sync_with_stdio(false);

    cin >> n;
    for (unsigned int i = 0 ; i < n - 1 ; i ++)
    {
        unsigned int a, b;
        cin >> a >> b;
        a --; b --;
        ln [a].push_back (b);
        ln [b].push_back (a);
    }
    auto vertex1 = deepest_child(0);
    for (auto& x : vertex1)
    {
        auto vertex2 = deepest_child(x.first);
        for (auto& y : vertex2)
            add_path_between (x.first, y.first);
    }

    for (auto& x : to_try)
    {
        unsigned int md = max_depth(x);
        if (md < answer)
        {
            answer = md;
            answers.clear();
            answers.push_back (x);
        }
        else if (md == answer)
        {
            answers.push_back (x);
        }
    }

    cout << answers.size () << endl;
    for (auto x : answers)
        cout << x + 1 << " ";
    cout << endl;
    return 0;
}

