#include <iostream>
#include <queue>
#include <vector>
#include <set>

using namespace std;

const unsigned int maxn = (1<<17);

vector < unsigned int > ln [maxn];
pair < unsigned int , unsigned int > levels [maxn]; /// <up, down>

bool visited [maxn];
unsigned int n;

void bfs (unsigned int start)
{
    for (unsigned int i = 0 ; i < n ; i ++)
    {
        visited [i] = false;
        levels[i] = {0, 0};
    }
    queue < unsigned int > q;
    q.push (start); levels [start].first = 0;
    visited [start] = true;

    while (!q.empty ())
    {
        auto front = q.front(); q.pop();
        //cout << front.second << endl;
        for (auto next : ln [front])
        {
            if (!visited [next])
            {
                visited [next] = true;
                q.push(next); levels [next].first = levels [front].first + 1;
            }
        }
    }
    return ;
}

unsigned int dfs (unsigned int start, unsigned int parent = -1)
{
    for (auto next : ln [start])
    {
        if (next != parent)
        {
            levels [start].second = max (levels [start].second, dfs (next, start) + 1);
        }
    }
    return levels [start].second;
}

unsigned int level_to_find = 1e9;

void evaluate (unsigned int vertex, unsigned int parent, unsigned int longest_other_branch)
{
    levels [vertex].first += longest_other_branch;
    level_to_find = min (level_to_find, max (levels[vertex].first, levels[vertex].second));
    for (auto next : ln [vertex])
    {
        if (next != parent)
        {
            evaluate(next, vertex, longest_other_branch);
        }
    }
}

set < unsigned int > answers;

void calc (unsigned int root)
{
    unsigned int first = levels [ln [root][0]].second, second = 0;
    if (first < second) swap (first, second);
    for (int i = 2 ; i < ln [root].size () ; i ++)
    {
        if (levels [ln [root][i]].second > first)
        {
            second = first;
            first = levels [ln [root][i]].second;
        }
        else if (levels [ln [root][i]].second > second)
        {
            second = levels [ln [root][i]].second;
        }
    }
    for (int i = 0 ; i < ln [root].size () ; i ++)
    {
        if (levels [ln [root][i]].second == first)
        {
            evaluate (ln [root][i], root, second + 1);
        }
        else if (levels [ln [root][i]].second == second)
        {
            evaluate (ln [root][i], root, first + 1);
        }
    }
    for (int i = 0 ; i < n ; i ++)
    {
        //cout << i + 1 << " " << levels[i].first << " " << levels[i].second << endl;
        if (max (levels[i].first, levels[i].second) == level_to_find)
        {
            answers.insert (i + 1);
        }
    }
}

int main ()
{
    cin.tie(nullptr);
    ios::sync_with_stdio(false);

    cin >> n;
    for (unsigned int i = 0 ; i < n - 1 ; i ++)
    {
        unsigned int a, b;
        cin >> a >> b;
        a --; b --;
        ln [a].push_back (b);
        ln [b].push_back (a);
    }
    unsigned int root = 0;
    bfs (root);
    dfs (root);
    calc(root);
    root = 1;
    bfs (root);
    dfs (root);
    calc(root);

    cout << answers.size () << endl;
    for (auto x : answers)
        cout << x << " ";
    cout << endl;
    return 0;
}

